<?php
/* --------------------------------------------------------------
   GambioAfterbuyModuleCenterModuleController.inc.php 2018-05-25
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2018 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

class GambioAfterbuyModuleCenterModuleController extends AbstractModuleCenterModuleController
{
    protected $configuration;
    
    
    protected function _init()
    {
        $this->pageTitle     = $this->languageTextManager->get_text('gambioafterbuy_title');
        $this->configuration = MainFactory::create('GambioAfterbuyConfigurationStorage');
    }
    
    
    public function actionDefault()
    {
        $title                  = new NonEmptyStringType($this->languageTextManager->get_text('gambioafterbuy_title'));
        $template               = $this->getTemplateFile('Gambio/Afterbuy/Admin/Html/gambioafterbuy_configuration.html');
        $orderStatusReadService = StaticGXCoreLoader::getService('OrderStatus');
        $orderStatuses          = [];
        
        /** @var OrderStatusInterface $orderStatus */
        foreach ($orderStatusReadService->findAll() as $orderStatus) {
            $orderStatuses[] = [
                'id'   => (string)$orderStatus->getId(),
                'name' => $orderStatus->getName(MainFactory::create('LanguageCode',
                                                                    new StringType($_SESSION['language_code']))),
            ];
        }
        
        $data = MainFactory::create('KeyValueCollection',
                                    [
                                        'pageToken'                 => $_SESSION['coo_page_token']->generate_token(),
                                        'configuration'             => $this->configuration->get_all(),
                                        'order_statuses'            => $orderStatuses,
                                        'cron_url'                  => xtc_catalog_href_link('shop.php',
                                                                                             'do=AfterbuyCron/SendOrders&key='
                                                                                             . LogControl::get_secure_token()),
                                        'action_save_configuration' => xtc_href_link('admin.php',
                                                                                     'do=GambioAfterbuyModuleCenterModule/SaveConfiguration'),
                                    ]);
        
        return MainFactory::create('AdminLayoutHttpControllerResponse', $title, $template, $data);
    }
    
    
    public function actionSaveConfiguration()
    {
        $this->_validatePageToken();
        
        $newConfiguration = $this->_getPostData('configuration');
        foreach ($newConfiguration as $key => $value) {
            try {
                $this->configuration->set($key, $value);
            } catch (Exception $e) {
                $GLOBALS['messageStack']->add_session($this->languageTextManager->get_text('error_saving_configuration'),
                                                      'error');
            }
        }
        $GLOBALS['messageStack']->add_session($this->languageTextManager->get_text('configuration_saved'), 'info');
        
        return MainFactory::create('RedirectHttpControllerResponse',
                                   xtc_href_link('admin.php', 'do=GambioAfterbuyModuleCenterModule'));
    }
    
}
